unit ncipv6analyzer;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, StdCtrls, ExtCtrls,
  ncstruct;

type

  { TfncIPv6Analyzer }

  TfncIPv6Analyzer = class(TFrame)
    edIP: TEdit;
    edMask: TEdit;
    edONetworkEnd: TEdit;
    edONetworkStart: TEdit;
    edOBlockType: TLabel;
    edOPrivate1: TLabel;
    lbIIP: TLabel;
    lbIMask: TLabel;
    lbONetworkEnd: TLabel;
    lbONetworkStart: TLabel;
    RadioGroup1: TRadioGroup;
    procedure edIPChange(Sender: TObject);
  private
    function FormatIPv6(AIn: TIPv6): string;
  public
    constructor Create(AOwner: TComponent); override;
  end;

implementation

{$R *.lfm}

uses
  nclang;

{ TfncIPv6Analyzer }

procedure TfncIPv6Analyzer.edIPChange(Sender: TObject);
const
  COLORS: array[Boolean] of TColor = (clRed, clBlack);
var
  AIsValid: Boolean;
  ip: TIPv6;
  mask: Byte;
begin
  // validation and mask conversion
  if (Sender = edIP) then
    AIsValid := IsValidIPv6(edIP.Text)
  else
  if (Sender = edMask) then
    AIsValid := StrToIntDef(edMask.Text, -1) in [0..128]
  else
    AIsValid := True;

  if Sender is TEdit then
    TEdit(Sender).Font.Color := COLORS[AIsValid];

  if AIsValid then
  begin
    ip.AsString := edIP.Text;
    mask := StrToIntDef(edMask.Text, 0);
    edOBlockType.Caption := IPv6BlockTypeToStr(IPv6BlockType(ip, mask));
    edONetworkStart.Text := FormatIPv6(IPv6NetworkStart(ip, mask));
    edONetworkEnd.Text := FormatIPv6(IPv6NetworkEnd(ip, mask));
  end
  else
  begin
    edOBlockType.Caption := '';
    edONetworkStart.Text := RS_INVALID_INPUT;
    edONetworkEnd.Text := RS_INVALID_INPUT;
  end;
end;

function TfncIPv6Analyzer.FormatIPv6(AIn: TIPv6): string;
begin
  case RadioGroup1.ItemIndex of
    0: Result := AIn.AsString;
    1: Result := AIn.AsAlternativeString;
    2: Result := AIn.AsCompressedString;
  end;
end;

constructor TfncIPv6Analyzer.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  edIP.Text := NS_DEFAULT_EMPTY_IPv6;
  edMask.Text := '128';
end;

end.

