unit nccatvbandwidth;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, StdCtrls, Graphics;

type

  { TfncCATVBandwidth }

  TfncCATVBandwidth = class(TFrame)
    edConstellation: TComboBox;
    edChannelWidth: TEdit;
    edInfoRate: TEdit;
    edSymbolRate: TEdit;
    edDataRate: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    procedure edChannelWidthChange(Sender: TObject);
  private
    FUpdating: Boolean;
  public
    { public declarations }
  end;

implementation

{$R *.lfm}

uses
  nclang;

{ TfncCATVBandwidth }

function Fmt(f: Double): string;
begin
  Result := Format('%.6f', [f]);
end;

procedure TfncCATVBandwidth.edChannelWidthChange(Sender: TObject);
{
  DVB: The Family of International Standards for Digital Video Broadcasting
  Table 10.4 page 231
  ISBN: 3-540-43545-X
}
const
  COLORS: array[Boolean] of TColor = (clRed, clBlack);
  CONSTELLATION_TO_BITS: array[0..10] of Byte =
    (2{QPSK}, 3{8-PSK}, 4{16-QAM}, 5{32-QAM},
     6{64-QAM}, 7{128-QAM}, 8{256-QAM}, 9{512-QAM},
     10{1024}, 11{2048}, 12{4096});
  ROLL_OFF_FACTOR = 0.15;
  REED_SOLOMON = 188/204;
var
  SymbolRate: Double;
  ChannelWidth: Double;
  DataRate: Double;
  InfoRate: Double;
  AIsValid: Boolean;
begin
  if FUpdating then
    Exit;

  FUpdating := True;
  try
    if Sender = edChannelWidth then
      AIsValid := StrToFloatDef(edChannelWidth.Text, -1) <> -1
    else
    if Sender = edConstellation then
      AIsValid := True
    else
    if Sender = edInfoRate then
      AIsValid := StrToFloatDef(edInfoRate.Text, -1) <> -1
    else
      AIsValid := True;

    if Sender is TEdit then
      TEdit(Sender).Font.Color := COLORS[AIsValid];

    if (Sender = edChannelWidth) or (Sender = edConstellation) then
    begin
      if AIsValid then
      begin
        ChannelWidth := StrToFloatDef(edChannelWidth.Text, 0);
        SymbolRate := ChannelWidth / (1+ROLL_OFF_FACTOR);
        DataRate := SymbolRate * CONSTELLATION_TO_BITS[edConstellation.ItemIndex];
        InfoRate := DataRate * REED_SOLOMON;

        edSymbolRate.Text := Fmt(SymbolRate);
        edDataRate.Text := Fmt(DataRate);
        edInfoRate.Text := Fmt(InfoRate);
      end
      else
      begin
        edSymbolRate.Text := RS_INVALID_INPUT;
        edDataRate.Text := RS_INVALID_INPUT;
        edInfoRate.Text := RS_INVALID_INPUT;
      end;
    end
    else
    if (Sender = edInfoRate) then
    begin
      if AIsValid then
      begin
        InfoRate := StrToFloatDef(edInfoRate.Text, 0);
        DataRate := InfoRate / REED_SOLOMON;
        SymbolRate := DataRate / CONSTELLATION_TO_BITS[edConstellation.ItemIndex];
        ChannelWidth := SymbolRate * (1+ROLL_OFF_FACTOR);

        edChannelWidth.Text := Fmt(ChannelWidth);
        edSymbolRate.Text := Fmt(SymbolRate);
        edDataRate.Text := Fmt(DataRate);
      end
      else
      begin
        edChannelWidth.Text := RS_INVALID_INPUT;
        edSymbolRate.Text := RS_INVALID_INPUT;
        edDataRate.Text := RS_INVALID_INPUT;
      end;
    end;

  finally
    FUpdating := False;
  end;
end;

end.

