unit ncipv4toipv6converter;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls;

type

  { TfncIPv4toIPv6Converter }

  TfncIPv4toIPv6Converter = class(TFrame)
    edIIPv4Host: TEdit;
    edIIPv4Server: TEdit;
    edIIPv4Port: TEdit;
    edOIPv66over4: TEdit;
    edOIPv6Mapped: TEdit;
    edOIPv6Compatible: TEdit;
    edOIPv6Teredo: TEdit;
    edOIPv6SIIT: TEdit;
    edOIPv66to4: TEdit;
    edOPrivate1: TLabel;
    GroupBox1: TGroupBox;
    lbIIPv4Port: TLabel;
    lbIIPv4Server: TLabel;
    lbOIPv66over4: TLabel;
    lbOIPv66over5: TLabel;
    lbOIPv6Mapped: TLabel;
    lbOIPv6SIIT: TLabel;
    lbOIPv66to4: TLabel;
    lbIIPv4Host: TLabel;
    lbOIPv6Compatible: TLabel;
    procedure edIIPv4HostChange(Sender: TObject);
  private
    { private declarations }
  end;

var
  fncIPv4toIPv6Converter: TfncIPv4toIPv6Converter;

implementation

{$R *.lfm}

uses
  ncstruct, nclang;

{ TfncIPv4toIPv6Converter }

procedure TfncIPv4toIPv6Converter.edIIPv4HostChange(Sender: TObject);
const
  COLORS: array[Boolean] of TColor = (clRed, clBlack);
var
  AIsValid: Boolean;
  ipv4: TIPv4;
  ipv6: TIPv6;
  i: Integer;
  hostValid: Boolean;
  serverValid: Boolean;
  portValid: Boolean;
begin
  hostValid := IsValidIPv4(edIIPv4Host.Text);
  serverValid := IsValidIPv4(edIIPv4Server.Text);
  i := StrToIntDef(edIIPv4Port.Text, -1);
  portValid := (0 <= i) and (i <= $ffff);

  if Sender = edIIPv4Host then
  begin
    AIsValid := hostValid;
  end
  else
  if Sender = edIIPv4Server then
  begin
    AIsValid := serverValid;
  end
  else
  if Sender = edIIPv4Port then
  begin
    AIsValid := portValid;
  end
  else
    AIsValid := True;

  if Sender is TEdit then
    TEdit(Sender).Font.Color := COLORS[AIsValid];

  ipv4.AsString := edIIPv4Host.Text;

  if hostValid then
  begin
    edOIPv6Compatible.Text := IPv4toIPv6Compatible(ipv4).AsString;
    edOIPv6Mapped.Text := IPv4toIPv6Mapped(ipv4).AsString;
    edOIPv66to4.Text := IPv4toIPv66to4(ipv4).AsString;
    edOIPv6SIIT.Text := IPv4toIPv6SIIT(ipv4).AsString;
    edOIPv66over4.Text := IPv4toIPv66over4(ipv4).AsString;
  end
  else
  begin
    edOIPv6Compatible.Text := RS_INVALID_INPUT;
    edOIPv6Mapped.Text := RS_INVALID_INPUT;
    edOIPv66to4.Text := RS_INVALID_INPUT;
    edOIPv6SIIT.Text := RS_INVALID_INPUT;
    edOIPv66over4.Text := RS_INVALID_INPUT;
  end;

  if hostValid and serverValid and portValid then
  begin
    edOIPv6Teredo.Text := IPv4toIPv6Teredo(ipv4,
                       StrToIPv4(edIIPv4Server.Text),
                       StrToInt(edIIPv4Port.Text)).AsString;
  end
  else
    edOIPv6Teredo.Text := RS_INVALID_INPUT;
end;

end.

