﻿unit ncMain;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls,
  ComCtrls, ExtCtrls, ncstruct;

type

  { TfncMain }

  TfncMain = class(TForm)
    eduV: TLabeledEdit;
    eddBV: TLabeledEdit;
    eddBmV: TLabeledEdit;
    edmV: TLabeledEdit;
    edV: TLabeledEdit;
    edmW: TLabeledEdit;
    eddBm: TLabeledEdit;
    eddBW: TLabeledEdit;
    edZc: TLabeledEdit;
    edW: TLabeledEdit;
    eddBuV: TLabeledEdit;
    Label1: TLabel;
    PageControl1: TPageControl;
    PageControl2: TPageControl;
    PageControl3: TPageControl;
    PageControl4: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    tsCATVBandwidth: TTabSheet;
    tsIPv6Analyze: TTabSheet;
    tsIPv6: TTabSheet;
    tsIPv4toIPv6: TTabSheet;
    tsIPv4: TTabSheet;
    tsIPv4Analyze: TTabSheet;
    tsIPv4Subnets: TTabSheet;
    procedure CalcFrommW(Sender: TObject);
    procedure edZcChange(Sender: TObject);
    procedure FormClose(Sender: TObject; var CloseAction: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure CalcFromV(Sender: TObject);
    procedure CatchException(Sender : TObject; E : Exception);
  private
    FIPv4Analyzer: TFrame;
    FIPv4Subnets: TFrame;
    FIPv4toIPv6Converter: TFrame;
    FIPv6Analyzer: TFrame;
    FCATVBandwidth: TFrame;
    FUpdatingmW: Boolean;
    FUpdatingV: Boolean;
  public
    procedure IPv4SubnetPageChange(Sender: TObject);
  end;

var
  fncMain: TfncMain;

implementation

{$R *.lfm}

uses
  ncipv4analyzer,
  ncipv4subnets,
  ncipv4toipv6converter,
  ncipv6analyzer,
  nccatvbandwidth,
  nclang,
  math;

function Fmt(f: Double): string;
begin
  Result := Format('%.6f', [f]);
end;

function Fmt(s: string): Double;
begin
  Result := StrToFloatDef(s, 0);
end;

function exp10(x: Double): Double;
begin
  Result := exp(x*ln(10));
end;

function dBV_to_dBuV(dBV: Double): Double;
begin
  Result := dBV + 120;
end;

function dBuV_to_dBV(dBuV: Double): Double;
begin
  Result := dBuV - 120;
end;

function dBmV_to_dBuV(dBmV: Double): Double;
begin
  Result := dBmV + 60;
end;

function dBuV_to_dBmV(dBuV: Double): Double;
begin
  Result := dBuV - 60;
end;

function V_to_dBV(V: Double): Double;
begin
  Result := 20 * log10(V);
end;

function V_to_dBuV(V: Double): Double;
var
  dBV: Double;
begin
  dBV := V_to_dBV(V);
  Result := dBV_to_dBuV(dBV);
end;

function dBV_to_V(dBV: Double): Double;
begin
  Result := exp10(dBV / 20);
end;

function dBuV_to_V(dBuV: Double): Double;
begin
  Result := dBV_to_V(dBuV_to_dBV(dBuV));
end;


function dBm_to_mW(dBm: Double): Double;
begin
  Result := power(10, dBm/10);
end;

function mW_to_dBm(mW: Double): Double;
begin
  Result := 10*log10(mW);
end;

function W_to_mW(W: Double): Double;
begin
  Result := W*1000;
end;

function mW_to_W(mW: Double): Double;
begin
  Result := mW/1000;
end;

function dBW_to_mW(dBW: Double): Double;
begin
  Result := power(10,(dBW+30)/10);
end;

function mW_to_dBW(mW: Double): Double;
begin
  Result := 10*log10(mw)-30;
end;

function dBm_to_dBuV(dBm, Imp: Double): Double;
var
  p, u: Double;
begin
  p := exp10(dbM / 10 ) / 1000;
  u := sqrt(p * Imp);
  Result := 20 * log10(u * 1000000);
end;

function dBuV_to_dBm(dBuV, Imp: Double): Double;
var
  u, p: Double;
begin
  u := exp10(dBuV / 20) / 1000000;
  p := u * u / Imp;
  Result := 10 * log10(p * 1000);
end;

function mV_to_V(mV: Double): Double;
begin
  Result := mV/1000;
end;

function uV_to_V(uV: Double): Double;
begin
  Result := uV/1000/1000;
end;

function V_to_mV(V: Double): Double;
begin
  Result := V*1000;
end;

function V_to_uV(V: Double): Double;
begin
  Result := V*1000*1000;
end;

function uV_to_dBuV(uV: Double): Double;
var
  V: Double;
begin
  V := uV_to_V(uV);
  Result := V_to_dBuV(V);
end;

function mV_to_dBuV(mV: Double): Double;
var
  V: Double;
begin
  V := mV_to_V(mV);
  Result := V_to_dBuV(V);
end;

function dBuV_to_mV(dBuV: Double): Double;
begin
  Result := V_to_mV(dBuV_to_V(dBuV));
end;

function dBuV_to_uV(dBuV: Double): Double;
begin
  Result := V_to_uV(dBuV_to_V(dBuV));
end;

{ TfncMain }

procedure TfncMain.FormCreate(Sender: TObject);
type
  TFrameClass = class of TFrame;

  function FrameCreate(AClass: TFrameClass; AParent: TTabSheet): TFrame;
  begin
    Result := AClass.Create(nil);
    Result.Align := alClient;
    Result.Parent := AParent;
  end;

begin
  Application.OnException := @CatchException;

  PageControl1.ActivePage := tsIPv4;
  PageControl2.ActivePage := tsIPv4Analyze;
  PageControl3.ActivePage := tsIPv6Analyze;
  PageControl4.ActivePage := tsCATVBandwidth;

  FIPv4Analyzer := FrameCreate(TfncIPv4Analyzer, tsIPv4Analyze);
  FIPv4Subnets := FrameCreate(TfncIPv4Subnets, tsIPv4Subnets);
  FIPv4toIPv6Converter := FrameCreate(TfncIPv4toIPv6Converter, tsIPv4toIPv6);
  FIPv6Analyzer := FrameCreate(TfncIPv6Analyzer, tsIPv6Analyze);
  FCATVBandwidth := FrameCreate(TfncCATVBandwidth, tsCATVBandwidth);

  TfncIPv4Analyzer(FIPv4Analyzer).OnSubnetClick := @IPv4SubnetPageChange;
end;

procedure TfncMain.CalcFromV(Sender: TObject);
var
  dBuV: Double;
begin
  if FUpdatingV then
    Exit;
  FUpdatingV := True;
  try
    // from
    if Sender = eddBV then     // dBV
    try
      dBuV := dBV_to_dBuV(Fmt(eddBV.Text));
    except
      dBuV := NaN;
    end;

    if Sender = eddBmV then     // dBmV
    try
      dBuV := dBmV_to_dBuV(Fmt(eddBmV.Text));
    except
      dBuV := NaN;
    end;

    if Sender = eddBuV then      // dBuV
    try
      dBuV := Fmt(eddBuV.Text);
    except
      dBuV := NaN;
    end;

    if Sender = edV then  // V
    try
      dBuV := V_to_dBuV(Fmt(edV.Text));
    except
      dBuV := NaN;
    end;

    if Sender = edmV then    // mV
    try
      dBuV := mV_to_dBuV(Fmt(edmV.Text));
    except
      dBuV := NaN;
    end;

    if Sender = eduV then    // uV
    try
      dBuV := uV_to_dBuV(Fmt(eduV.Text));
    except
      dBuV := NaN;
    end;

    // to

    if Sender <> eddBV then  // dBV
    try
      eddBV.Text := Fmt(dBuV_to_dBV(dBuV));
    except
      eddBV.Text := RS_INVALID_INPUT;
    end;

    if Sender <> eddBmV then  // dBmV
    try
      eddBmV.Text := Fmt(dBuV_to_dBmV(dBuV));
    except
      eddBmV.Text := RS_INVALID_INPUT;
    end;

    if Sender <> eddBuV then  // dBuV
    try
      eddBuV.Text := Fmt(dBuV);
    except
      eddBuV.Text := RS_INVALID_INPUT;
    end;

    if Sender <> edV then     // V
    try
      edV.Text := Fmt(dBuV_to_V(dBuV));
    except
      edV.Text := RS_INVALID_INPUT;
    end;

    if Sender <> edmV then   // mV
    try
      edmV.Text := Fmt(dBuV_to_mV(dBuV));
    except
      edmV.Text := RS_INVALID_INPUT;
    end;

    if Sender <> eduV then   // uV
    try
      eduV.Text := Fmt(dBuV_to_uV(dBuV));
    except
      edmV.Text := RS_INVALID_INPUT;
    end;

    if not FUpdatingmW then
    begin
      eddBm.Text := Fmt(dBuV_to_dBm(Fmt(eddBuV.Text), Fmt(edZc.Text)));
      CalcFrommW(eddBm);
    end;
  finally
    FUpdatingV := False;
  end;
end;

procedure TfncMain.CatchException(Sender: TObject; E: Exception);
begin
  //FUpdatingmW := False;
  //FUpdatingV := False;
end;

procedure TfncMain.FormClose(Sender: TObject; var CloseAction: TCloseAction);
begin
  if Assigned(FIPv6Analyzer) then
    FIPv6Analyzer.Free;
  if Assigned(FIPv4toIPv6Converter) then
    FIPv4toIPv6Converter.Free;
  if Assigned(FIPv4Analyzer) then
    FIPv4Analyzer.Free;
  if Assigned(FIPv4Subnets) then
    FIPv4Subnets.Free;
end;

procedure TfncMain.CalcFrommW(Sender: TObject);
var
  mW: Double;
begin
  if FUpdatingmW then
    Exit;
  FUpdatingmW := True;
  try
    // from
    if Sender = edmW then
    try
      mW := Fmt(edmW.Text);
    except
      mW := NaN;
    end;

    if Sender = eddBm then
    try
      mW := dBm_to_mW(Fmt(eddBm.Text));
    except
      mW := NaN
    end;

    if Sender = edW then
    try
      mW := W_to_mW(Fmt(edW.Text));
    except
      mW := NaN;
    end;

    if Sender = eddBW then
    try
      mW := dBW_to_mW(Fmt(eddBW.Text));
    except
      mW := NaN;
    end;

    // to
    if Sender <> edmW then
      edmW.Text := Fmt(mw);

    if Sender <> edW then
      edW.Text := Fmt(mW_to_W(mW));

    if Sender <> eddBm then
    try
      eddBm.Text := Fmt(mW_to_dBm(mW));
    except
      eddBm.Text := RS_INVALID_INPUT;
    end;

    if Sender <> eddBW then
    try
      eddBW.Text := Fmt(mW_to_dBW(mW));
    except
      eddBW.Text := RS_INVALID_INPUT;
    end;

    if not FUpdatingV then
    begin
      eddBuV.Text := Fmt(dBm_to_dBuV(Fmt(eddBm.Text), Fmt(edZc.Text)));
      CalcFromV(eddBuV);
    end;
  finally
    FUpdatingmW := False;
  end;
end;

procedure TfncMain.edZcChange(Sender: TObject);
begin
  FUpdatingmW := True;
  try
    try
      eddBuV.Text := Fmt(dBm_to_dBuV(Fmt(eddBm.Text), Fmt(edZc.Text)));
      CalcFromV(eddBuV);
    except
      eddBuV.Text := RS_INVALID_INPUT;
      eddBV.Text := RS_INVALID_INPUT;
      edV.Text := RS_INVALID_INPUT;
    end;
  finally
    FUpdatingmW := False;
  end;
end;

procedure TfncMain.IPv4SubnetPageChange(Sender: TObject);
var
  i: Integer;
begin
  i := StrToIntDef(TfncIPv4Analyzer(FIPv4Analyzer).edCIDR.Text, -1);
  if IsValidIPv4(TfncIPv4Analyzer(FIPv4Analyzer).edONetwork.Text) and
     IsValidIPv4(TfncIPv4Analyzer(FIPv4Analyzer).edOBroadcast.Text) and
     ((i >= 0) and (i < 32)) then
  begin
    PageControl2.ActivePageIndex := 1;
    TfncIPv4Subnets(FIPv4Subnets).edIPFrom.Text := TfncIPv4Analyzer(FIPv4Analyzer).edONetwork.Text;
    TfncIPv4Subnets(FIPv4Subnets).edIPTo.Text := TfncIPv4Analyzer(FIPv4Analyzer).edOBroadcast.Text;
    if Sender = TfncIPv4Analyzer(FIPv4Analyzer).edOSubnets then
    begin
      TfncIPv4Subnets(FIPv4Subnets).ListView1.ItemIndex := TfncIPv4Subnets(FIPv4Subnets).ListView1.Items.Count - 1
    end
    else
      TfncIPv4Subnets(FIPv4Subnets).ListView1.ItemIndex := 0;
  end
  else
    MessageDlg(RS_INCORRECT_DATA, mtInformation, [mbOk], 0);
end;

end.

