unit ncselfcheck;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils;

function IPv6SelfCheck: Boolean;

implementation

uses
  ncstruct;

function IPv6SelfCheck: Boolean;

  procedure XTEST(a: Boolean; b, c: string);
  begin
    if a <> IsValidIPv6(b) then
    begin
      raise Exception.Create(b);
    end;
  end;

begin
  XTEST(false,'','---');
  XTEST(true ,'2001:0000:1234:0000:0000:C1C0:ABCD:0876','2001:0:1234::C1C0:ABCD:876');
  XTEST(true ,'3ffe:0b00:0000:0000:0001:0000:0000:000a','3ffe:b00::1:0:0:a');
  XTEST(true ,'FF02:0000:0000:0000:0000:0000:0000:0001','FF02::1');
  XTEST(true ,'0000:0000:0000:0000:0000:0000:0000:0001','::1');
  XTEST(true ,'0000:0000:0000:0000:0000:0000:0000:0000','::');
  XTEST(true ,'::ffff:192.168.1.26','::ffff:192.168.1.26');
  XTEST(false,'02001:0000:1234:0000:0000:C1C0:ABCD:0876','---');
  XTEST(false,'2001:0000:1234:0000:00001:C1C0:ABCD:0876','---');
  XTEST(true ,' 2001:0000:1234:0000:0000:C1C0:ABCD:0876',' 2001:0:1234::C1C0:ABCD:876');
  XTEST(true ,' 2001:0000:1234:0000:0000:C1C0:ABCD:0876  ',' 2001:0:1234::C1C0:ABCD:876  ');
  XTEST(false,' 2001:0000:1234:0000:0000:C1C0:ABCD:0876  0','---');
  XTEST(false,'2001:0000:1234: 0000:0000:C1C0:ABCD:0876','---');
  XTEST(false,'2001:1:1:1:1:1:255Z255X255Y255','---');

  //??XTEST(false,'3ffe:0b00:0000:0001:0000:0000:000a','---');
  XTEST(false,'FF02:0000:0000:0000:0000:0000:0000:0000:0001','---');
  XTEST(false,'3ffe:b00::1::a','---');
  XTEST(false,'::1111:2222:3333:4444:5555:6666::','---');
  XTEST(true ,'2::10','2::10');
  XTEST(true ,'ff02::1','ff02::1');
  XTEST(true ,'fe80::','fe80::');
  XTEST(true ,'2002::','2002::');
  XTEST(true ,'2001:db8::','2001:db8::');
  XTEST(true ,'2001:0db8:1234::','2001:db8:1234::');
  XTEST(true ,'::ffff:0:0','::ffff:0:0');
  XTEST(true ,'::1','::1');
  XTEST(true ,'::ffff:192.168.1.1','::ffff:192.168.1.1');
  XTEST(true ,'1:2:3:4:5:6:7:8','1:2:3:4:5:6:7:8');
  XTEST(true ,'1:2:3:4:5:6::8','1:2:3:4:5:6:0:8');
  XTEST(true ,'1:2:3:4:5::8','1:2:3:4:5::8');
  XTEST(true ,'1:2:3:4::8','1:2:3:4::8');
  XTEST(true ,'1:2:3::8','1:2:3::8');
  XTEST(true ,'1:2::8','1:2::8');
  XTEST(true ,'1::8','1::8');
  XTEST(true ,'1::2:3:4:5:6:7','1:0:2:3:4:5:6:7');
  XTEST(true ,'1::2:3:4:5:6','1::2:3:4:5:6');
  XTEST(true ,'1::2:3:4:5','1::2:3:4:5');
  XTEST(true ,'1::2:3:4','1::2:3:4');
  XTEST(true ,'1::2:3','1::2:3');
  XTEST(true ,'1::8','1::8');
  XTEST(true ,'::2:3:4:5:6:7:8','0:2:3:4:5:6:7:8');
  XTEST(true ,'::2:3:4:5:6:7','::2:3:4:5:6:7');
  XTEST(true ,'::2:3:4:5:6','::2:3:4:5:6');
  XTEST(true ,'::2:3:4:5','::2:3:4:5');
  XTEST(true ,'::2:3:4','::2:3:4');
  XTEST(true ,'::2:3','::2:3');
  XTEST(true ,'::8','::8');
  XTEST(true ,'1:2:3:4:5:6::','1:2:3:4:5:6::');
  XTEST(true ,'1:2:3:4:5::','1:2:3:4:5::');
  XTEST(true ,'1:2:3:4::','1:2:3:4::');
  XTEST(true ,'1:2:3::','1:2:3::');
  XTEST(true ,'1:2::','1:2::');
  XTEST(true ,'1::','1::');
  XTEST(true ,'1:2:3:4:5::7:8','1:2:3:4:5:0:7:8');
  XTEST(false,'1:2:3::4:5::7:8','---');
  XTEST(false,'12345::6:7:8','---');
  XTEST(true ,'1:2:3:4::7:8','1:2:3:4::7:8');
  XTEST(true ,'1:2:3::7:8','1:2:3::7:8');
  XTEST(true ,'1:2::7:8','1:2::7:8');
  XTEST(true ,'1::7:8','1::7:8');
  XTEST(true ,'1:2:3:4:5:6:1.2.3.4','1:2:3:4:5:6:1.2.3.4');
  XTEST(true ,'1:2:3:4:5::1.2.3.4','1:2:3:4:5:0:1.2.3.4');
  XTEST(true ,'1:2:3:4::1.2.3.4','1:2:3:4::1.2.3.4');
  XTEST(true ,'1:2:3::1.2.3.4','1:2:3::1.2.3.4');
  XTEST(true ,'1:2::1.2.3.4','1:2::1.2.3.4');
  XTEST(true ,'1::1.2.3.4','1::1.2.3.4');
  XTEST(true ,'1:2:3:4::5:1.2.3.4','1:2:3:4:0:5:1.2.3.4');
  XTEST(true ,'1:2:3::5:1.2.3.4','1:2:3::5:1.2.3.4');
  XTEST(true ,'1:2::5:1.2.3.4','1:2::5:1.2.3.4');
  XTEST(true ,'1::5:1.2.3.4','1::5:1.2.3.4');
  XTEST(true ,'1::5:11.22.33.44','1::5:11.22.33.44');
  XTEST(false,'1::5:400.2.3.4','---');
  XTEST(false,'1::5:260.2.3.4','---');
  XTEST(false,'1::5:256.2.3.4','---');
  XTEST(false,'1::5:1.256.3.4','---');
  XTEST(false,'1::5:1.2.256.4','---');
  XTEST(false,'1::5:1.2.3.256','---');
  XTEST(false,'1::5:300.2.3.4','---');
  XTEST(false,'1::5:1.300.3.4','---');
  XTEST(false,'1::5:1.2.300.4','---');
  XTEST(false,'1::5:1.2.3.300','---');
  XTEST(false,'1::5:900.2.3.4','---');
  XTEST(false,'1::5:1.900.3.4','---');
  XTEST(false,'1::5:1.2.900.4','---');
  XTEST(false,'1::5:1.2.3.900','---');
  XTEST(false,'1::5:300.300.300.300','---');
  XTEST(false,'1::5:3000.30.30.30','---');
  XTEST(false,'1::400.2.3.4','---');
  XTEST(false,'1::260.2.3.4','---');
  XTEST(false,'1::256.2.3.4','---');
  XTEST(false,'1::1.256.3.4','---');
  XTEST(false,'1::1.2.256.4','---');
  XTEST(false,'1::1.2.3.256','---');
  XTEST(false,'1::300.2.3.4','---');
  XTEST(false,'1::1.300.3.4','---');
  XTEST(false,'1::1.2.300.4','---');
  XTEST(false,'1::1.2.3.300','---');
  XTEST(false,'1::900.2.3.4','---');
  XTEST(false,'1::1.900.3.4','---');
  XTEST(false,'1::1.2.900.4','---');
  XTEST(false,'1::1.2.3.900','---');
  XTEST(false,'1::300.300.300.300','---');
  XTEST(false,'1::3000.30.30.30','---');
  XTEST(false,'::400.2.3.4','---');
  XTEST(false,'::260.2.3.4','---');
  XTEST(false,'::256.2.3.4','---');
  XTEST(false,'::1.256.3.4','---');
  XTEST(false,'::1.2.256.4','---');
  XTEST(false,'::1.2.3.256','---');
  XTEST(false,'::300.2.3.4','---');
  XTEST(false,'::1.300.3.4','---');
  XTEST(false,'::1.2.300.4','---');
  XTEST(false,'::1.2.3.300','---');
  XTEST(false,'::900.2.3.4','---');
  XTEST(false,'::1.900.3.4','---');
  XTEST(false,'::1.2.900.4','---');
  XTEST(false,'::1.2.3.900','---');
  XTEST(false,'::300.300.300.300','---');
  XTEST(false,'::3000.30.30.30','---');
  XTEST(true ,'fe80::217:f2ff:254.7.237.98','fe80::217:f2ff:254.7.237.98');
  XTEST(true ,'fe80::217:f2ff:fe07:ed62','fe80::217:f2ff:fe07:ed62');
  XTEST(true ,'2001:DB8:0:0:8:800:200C:417A','2001:DB8::8:800:200C:417A');
  XTEST(true ,'FF01:0:0:0:0:0:0:101','FF01::101');
  XTEST(true ,'0:0:0:0:0:0:0:1','::1');
  XTEST(true ,'0:0:0:0:0:0:0:0','::');
  XTEST(true ,'2001:DB8::8:800:200C:417A','2001:DB8::8:800:200C:417A');
  XTEST(true ,'FF01::101','FF01::101');
  XTEST(true ,'::1','::1');
  XTEST(true ,'::','::');
  XTEST(true ,'0:0:0:0:0:0:13.1.68.3','::13.1.68.3');
  XTEST(true ,'0:0:0:0:0:FFFF:129.144.52.38','::FFFF:129.144.52.38');
  XTEST(true ,'::13.1.68.3','::13.1.68.3');
  XTEST(true ,'::FFFF:129.144.52.38','::FFFF:129.144.52.38');
// 	# XTEST(true ,'2001:0DB8:0000:CD30:0000:0000:0000:0000/60','2001:0DB8:0000:CD30:0000:0000:0000:0000/60');
// 	# XTEST(true ,'2001:0DB8::CD30:0:0:0:0/60','2001:0DB8::CD30:0:0:0:0/60');
// 	# XTEST(true ,'2001:0DB8:0:CD30::/60','2001:0DB8:0:CD30::/60');
// 	# XTEST(true ,'::/128','::/128');
// 	# XTEST(true ,'::1/128','::1/128');
// 	# XTEST(true ,'FF00::/8','FF00::/8');
// 	# XTEST(true ,'FE80::/10','FE80::/10');
// 	# XTEST(true ,'FEC0::/10','FEC0::/10');
// 	# XTEST(false,'124.15.6.89/60','---');
  XTEST(false,'2001:DB8:0:0:8:800:200C:417A:221','---');
  XTEST(false,'FF01::101::2','---');
  XTEST(false,'','---');

  XTEST(true ,'fe80:0000:0000:0000:0204:61ff:fe9d:f156','fe80::204:61ff:fe9d:f156');
  XTEST(true ,'fe80:0:0:0:204:61ff:fe9d:f156','fe80::204:61ff:fe9d:f156');
  XTEST(true ,'fe80::204:61ff:fe9d:f156','fe80::204:61ff:fe9d:f156');
  //??XTEST(false,'fe80:0000:0000:0000:0204:61ff:254.157.241.086','---');
  XTEST(true ,'fe80:0:0:0:204:61ff:254.157.241.86','fe80::204:61ff:254.157.241.86');
  XTEST(true ,'fe80::204:61ff:254.157.241.86','fe80::204:61ff:254.157.241.86');
  XTEST(true ,'::1','::1');
  XTEST(true ,'fe80::','fe80::');
  XTEST(true ,'fe80::1','fe80::1');
  XTEST(false,':','---');

// Aeron supplied these test cases.
  XTEST(false,'1111:2222:3333:4444::5555:','---');
  XTEST(false,'1111:2222:3333::5555:','---');
  XTEST(false,'1111:2222::5555:','---');
  XTEST(false,'1111::5555:','---');
  XTEST(false,'::5555:','---');
  XTEST(false,':::','---');
  XTEST(false,'1111:','---');
  XTEST(false,':','---');

  XTEST(false,':1111:2222:3333:4444::5555','---');
  XTEST(false,':1111:2222:3333::5555','---');
  XTEST(false,':1111:2222::5555','---');
  XTEST(false,':1111::5555','---');
  XTEST(false,':::5555','---');
  XTEST(false,':::','---');

  XTEST(false,'1.2.3.4:1111:2222:3333:4444::5555','---');
  XTEST(false,'1.2.3.4:1111:2222:3333::5555','---');
  XTEST(false,'1.2.3.4:1111:2222::5555','---');
  XTEST(false,'1.2.3.4:1111::5555','---');
  XTEST(false,'1.2.3.4::5555','---');
  XTEST(false,'1.2.3.4::','---');

// Additional Patterns
// from http://rt.cpan.org/Public/Bug/Display.html?id=50693

  XTEST(true ,'2001:0db8:85a3:0000:0000:8a2e:0370:7334','2001:db8:85a3::8a2e:370:7334');
  XTEST(true ,'2001:db8:85a3:0:0:8a2e:370:7334','2001:db8:85a3::8a2e:370:7334');
  XTEST(true ,'2001:db8:85a3::8a2e:370:7334','2001:db8:85a3::8a2e:370:7334');
  XTEST(true ,'2001:0db8:0000:0000:0000:0000:1428:57ab','2001:db8::1428:57ab');
  XTEST(true ,'2001:0db8:0000:0000:0000::1428:57ab','2001:db8::1428:57ab');
  XTEST(true ,'2001:0db8:0:0:0:0:1428:57ab','2001:db8::1428:57ab');
  XTEST(true ,'2001:0db8:0:0::1428:57ab','2001:db8::1428:57ab');
  XTEST(true ,'2001:0db8::1428:57ab','2001:db8::1428:57ab');
  XTEST(true ,'2001:db8::1428:57ab','2001:db8::1428:57ab');
  XTEST(true ,'0000:0000:0000:0000:0000:0000:0000:0001','::1');
  XTEST(true ,'::1','::1');
  XTEST(true ,'::ffff:12.34.56.78','::ffff:12.34.56.78');
  XTEST(true ,'::ffff:0c22:384e','::ffff:c22:384e');
  XTEST(true ,'2001:0db8:1234:0000:0000:0000:0000:0000','2001:db8:1234::');
  XTEST(true ,'2001:0db8:1234:ffff:ffff:ffff:ffff:ffff','2001:db8:1234:ffff:ffff:ffff:ffff:ffff');
  XTEST(true ,'2001:db8:a::123','2001:db8:a::123');
  XTEST(true ,'fe80::','fe80::');
  XTEST(true ,'::ffff:192.0.2.128','::ffff:192.0.2.128');
  XTEST(true ,'::ffff:c000:280','::ffff:c000:280');

  XTEST(false,'123','---');
  XTEST(false,'ldkfj','---');
  XTEST(false,'2001::FFD3::57ab','---');
  XTEST(false,'2001:db8:85a3::8a2e:37023:7334','---');
  XTEST(false,'2001:db8:85a3::8a2e:370k:7334','---');
  XTEST(false,'1:2:3:4:5:6:7:8:9','---');
  XTEST(false,'1::2::3','---');
  XTEST(false,'1:::3:4:5','---');
  XTEST(false,'1:2:3::4:5:6:7:8:9','---');
  XTEST(false,'::ffff:2.3.4','---');
  XTEST(false,'::ffff:257.1.2.3','---');
  XTEST(false,'1.2.3.4','---');

// Test collapsing zeroes...

  XTEST(true ,'a:b:c:d:e:f:f1:f2','a:b:c:d:e:f:f1:f2');
  XTEST(true ,'a:b:c::d:e:f:f1','a:b:c:0:d:e:f:f1');
  XTEST(true ,'a:b:c::d:e:f','a:b:c::d:e:f');
  XTEST(true ,'a:b:c::d:e','a:b:c::d:e');
  XTEST(true ,'a:b:c::d','a:b:c::d');
  XTEST(true ,'::a','::a');
  XTEST(true ,'::a:b:c','::a:b:c');
  XTEST(true ,'::a:b:c:d:e:f:f1','0:a:b:c:d:e:f:f1');
  XTEST(true ,'a::','a::');
  XTEST(true ,'a:b:c::','a:b:c::');
  XTEST(true ,'a:b:c:d:e:f:f1::','a:b:c:d:e:f:f1:0');
  XTEST(true ,'a:bb:ccc:dddd:000e:00f:0f::','a:bb:ccc:dddd:e:f:f:0');
  XTEST(true ,'0:a:0:a:0:0:0:a','0:a:0:a::a');
  XTEST(true ,'0:a:0:0:a:0:0:a','0:a::a:0:0:a');
  XTEST(true ,'2001:db8:1:1:1:1:0:0','2001:db8:1:1:1:1::');
  XTEST(true ,'2001:db8:1:1:1:0:0:0','2001:db8:1:1:1::');
  XTEST(true ,'2001:db8:1:1:0:0:0:0','2001:db8:1:1::');
  XTEST(true ,'2001:db8:1:0:0:0:0:0','2001:db8:1::');
  XTEST(true ,'2001:db8:0:0:0:0:0:0','2001:db8::');
  XTEST(true ,'2001:0:0:0:0:0:0:0','2001::');

  XTEST(true ,'A:BB:CCC:DDDD:000E:00F:0F::','A:BB:CCC:DDDD:E:F:F:0');

  XTEST(true ,'0:0:0:0:0:0:0:0','::');
  XTEST(true ,'0:0:0:0:0:0:0:a','::a');
  XTEST(true ,'0:0:0:0:a:0:0:0','::a:0:0:0');
  XTEST(true ,'0:0:0:a:0:0:0:0','0:0:0:a::');
  XTEST(true ,'0:a:0:0:a:0:0:a','0:a::a:0:0:a');
  XTEST(true ,'a:0:0:a:0:0:a:a','a::a:0:0:a:a');
  XTEST(true ,'a:0:0:a:0:0:0:a','a:0:0:a::a');
  XTEST(true ,'a:0:0:0:a:0:0:a','a::a:0:0:a');
  XTEST(true ,'a:0:0:0:a:0:0:0','a::a:0:0:0');
  XTEST(true ,'a:0:0:0:0:0:0:0','a::');
end;

end.
