unit ncipv4subnets;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls,
  ComCtrls, ncstruct;

type

  { TfncIPv4Subnets }

  TfncIPv4Subnets = class(TFrame)
    edIPFrom: TEdit;
    edIPTo: TEdit;
    Label1: TLabel;
    lbIRange: TLabel;
    ListView1: TListView;
    ListView2: TListView;
    procedure edIPFromChange(Sender: TObject);
    procedure ListView1SelectItem(Sender: TObject; Item: TListItem;
      Selected: Boolean);
  private
    FLastIsValid: Boolean;
    FLastNetwork: TIPv4;
  public
    constructor Create(AOwner: TComponent); override;
  end;

var
  fncIPv4Sum: TfncIPv4Subnets;

implementation

{$R *.lfm}

uses
  Math, nclang;

{ TfncIPv4Subnets }

procedure TfncIPv4Subnets.edIPFromChange(Sender: TObject);
var
  ipf, ipt: TIPv4;
  m: TIPv4;
  j, i: Integer;
  h, n, a: Int64;
  x: TListItem;
  AIsValid: Boolean;
var
  COLORS: array[Boolean] of TColor = (clRed, clBlack);
begin
  if Sender = edIPFrom then
    AIsValid := IsValidIPv4(edIPFrom.Text)
  else
  if Sender = edIPTo then
    AIsValid := IsValidIPv4(edIPTo.Text)
  else
    AIsValid := True;

  if Sender is TEdit then
    TEdit(Sender).Font.Color := COLORS[AIsValid];

  if IsValidIPv4(edIPFrom.Text) and IsValidIPv4(edIPTo.Text) then
    AIsValid := StrToIPv4(edIPFrom.Text) <= StrToIPv4(edIPTo.Text);

  if AIsValid then
  begin
    ipf := StrToIPv4(edIPFrom.Text);
    ipt := StrToIPv4(edIPTo.Text);
    i := IPv4SimilarBits(ipf, ipt);
    FLastNetwork := IPv4Network(ipf, CIDRToMask(i));
    if i < 31 then
    begin
      ListView1.BeginUpdate;
      ListView2.BeginUpdate;
      try
        ListView1.Clear;
        ListView2.Clear;
        a := IPv4HostsAndNetwork(CIDRToMask(i))+1;
        for j := i to 30 do
        begin
          m := CIDRToMask(j);
          h := IPv4Hosts(m);
          n := 1 shl (j-i); // subnets

          x := ListView1.Items.Add;

          x.Caption := CIDRToMask(j).AsString;
          x.SubItems.Add(IntToStr(j));
          x.SubItems.Add(IntToStr(h));
          x.SubItems.Add(IntToStr(n));
          x.SubItems.Add(IntToStr(h*n));
          x.SubItems.Add(Format('%.2f', [((h*n)/a)*100]));
        end;
      finally
        ListView2.EndUpdate;
        ListView1.EndUpdate;
      end;
    end
    else
    begin
      ListView1.BeginUpdate;
      ListView2.BeginUpdate;
      try
        ListView1.Clear;
        ListView2.Clear;
      finally
        ListView2.EndUpdate;
        ListView1.EndUpdate;
      end;
      AIsValid := False;
    end;
  end
  else
  begin
    ListView1.BeginUpdate;
    ListView2.BeginUpdate;
    try
      ListView1.Clear;
      ListView2.Clear;
    finally
      ListView2.EndUpdate;
      ListView1.EndUpdate;
    end;
    AIsValid := False;
  end;

  FLastIsValid := AIsValid;
end;

procedure TfncIPv4Subnets.ListView1SelectItem(Sender: TObject; Item: TListItem;
  Selected: Boolean);
var
  j, i, h: Integer;
  w: TIPv4;
  x: TListItem;
  m: TIPv4;
begin
  if not FLastIsValid then
    Exit;

  if not Assigned(Item) then
    Exit;

  ListView2.BeginUpdate;
  try
    ListView2.Clear;
    i := StrToIntDef(Item.SubItems[2], 1);
    h := StrToIntDef(Item.SubItems[1], 1);
    w := FLastNetwork;
    m := StrToIPv4(Item.Caption);
    for j := 1 to Min(i, 1024) do
    begin
      x := ListView2.Items.Add;
      x.Caption := w.AsString;
      x.SubItems.Add(IPv4FirstHost(w, m).AsString + ' - ' + IPv4LastHost(w, m).AsString);
      x.SubItems.Add(IPv4Broadcast(w, m).AsString);
      w.AsDWord := w.AsDWord + h + 2;
    end;

    if i > 1024 then
    begin
      x := ListView2.Items.Add;
      x.SubItems.Add(Format(RS_LIMITED_TO_X, [1024]));
    end;
  finally
    ListView2.EndUpdate;
  end;
end;

constructor TfncIPv4Subnets.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  edIPFrom.Text := NS_DEFAULT_EMPTY_IPv4;
  edIPTo.Text := NS_DEFAULT_EMPTY_IPv4;
  edIPFromChange(nil);
end;

end.

